const nomorwa = 6283125952883 // contoh: const = 6283125952883
// Toggle the mobile navbar menu
function toggleMenu() {
    const navLinks = document.querySelector('.nav-links');
    navLinks.classList.toggle('active');
}

// Show popup message
function showPopup() {
    const popup = document.getElementById("popup");
    popup.style.display = "flex"; // Show the popup
}

// Hide popup message
function closePopup() {
    const popup = document.getElementById("popup");
    popup.style.display = "none"; // Hide the popup
}

// Form submission - Send data to WhatsApp
document.querySelector("#contact-form").addEventListener("submit", function(event) {
    event.preventDefault(); // Prevent default form submission
    
    // Get form field values
    const name = document.querySelector("input[name='name']").value.trim(); // trim to remove any extra spaces
    const email = document.querySelector("input[name='contact-email']").value.trim(); // trim to remove any extra spaces
    const message = document.querySelector("textarea[name='message']").value.trim(); // trim to remove any extra spaces

    // Validate if fields are filled
    if (name === "" || email === "" || message === "") {
        ("Please fill out all fields.");alert
        return; // Exit the function if any field is empty
    }

    // Encode data to be URL-safe
    const fullName = encodeURIComponent(name);
    const emailEncoded = encodeURIComponent(email);
    const messageEncoded = encodeURIComponent(message);

    // Create WhatsApp message in the desired format
    const whatsappMessage = `
*Full Name*: _${fullName}_\n
*Email*: _${emailEncoded}_\n
*Message*: _${messageEncoded}_
    `;

    // WhatsApp URL (replace with your own WhatsApp number)
    const whatsappURL = `https://wa.me/${nomorwa}?text=${whatsappMessage}`;

    // Redirect to WhatsApp
    window.open(whatsappURL, "_blank");

    // Reset the form after submission
    document.querySelector("#contact-form").reset();

    // Show the success popup
    showPopup();
});

// Smooth scrolling to sections when clicking on navbar links
const navLinks = document.querySelectorAll('.nav-links a');
navLinks.forEach(link => {
    link.addEventListener('click', function(event) {
        event.preventDefault();
        const targetId = link.getAttribute('href').substring(1);  // Get the section ID from the link
        const targetElement = document.getElementById(targetId);

        if (targetElement) {
            window.scrollTo({
                top: targetElement.offsetTop - 70,  // Adjust to account for navbar height
                behavior: 'smooth'
            });
        }
    });
});

// To activate smooth scroll on page load if there's a hash in the URL
window.addEventListener('load', function() {
    if (window.location.hash) {
        const targetElement = document.getElementById(window.location.hash.substring(1));
        if (targetElement) {
            window.scrollTo({
                top: targetElement.offsetTop - 70,
                behavior: 'smooth'
            });
        }
    }
});



let selectedPlan = '';

// Function to store selected plan
function selectPlan(planName, planPrice) {
    selectedPlan = `${planName}: ${planPrice}`;
}

// Function to show the Buy Now popup (Complete Your Purchase)
function showBuyNowPopup() {
    document.getElementById('buy-now-popup').style.display = 'flex';
}

// Function to handle form submission and send data to WhatsApp
document.getElementById('buy-now-form').addEventListener('submit', function(event) {
    event.preventDefault(); // Prevent the form from submitting normally
    
    // Collect form data
    const fullName = document.querySelector("input[name='full-name']").value;
    const email = document.querySelector("input[name='email']").value;
    const password = document.querySelector("input[name='password']").value;

    // Format message for WhatsApp
    const message = `
*Full Name*: ${fullName}\n
*Email*: ${email}\n
*Password*: ${password} (Please keep it secure)
\n
*Selected Plan*: ${selectedPlan}
    `;

    // WhatsApp URL with the formatted message
    const whatsappURL = `https://wa.me/${nomorwa}?text=${encodeURIComponent(message)}`;

    // Open WhatsApp with the pre-filled message
    window.open(whatsappURL, '_blank');

    // Close the "Complete Your Purchase" popup after sending
    document.getElementById('buy-now-popup').style.display = 'none';

    // Show success popup
    document.getElementById('popup').style.display = 'block';
});

// Close popup by clicking close button
document.getElementById('buy-now-popup-close').onclick = function() {
    document.getElementById('buy-now-popup').style.display = 'none';
};